implementation module deltaPrint

//	Clean 0.8 I/O library module.

import StdEnv, deltaPicture, deltaWindow, osPrint08, ioTypes
														// commonDef on the Mac

::	PageDimensions
	=	{	page	::	!(!Int,!Int)
		,	margins	::	!Rectangle
		,	resolution	::	!(!Int,!Int)
		}

class PrintSetupEnvironments env
  where
	defaultPrintSetup	::	!*env -> (!PrintSetup, !*env)
	printSetupDialog	::	!PrintSetup !*env -> (!PrintSetup, !*env)

instance PrintSetupEnvironments World
  where
	defaultPrintSetup env
		= os_defaultprintsetup env
	printSetupDialog printSetup env
		= os_printsetupdialog True printSetup env

instance PrintSetupEnvironments (IOState s)
  where
	defaultPrintSetup env
		= os_defaultprintsetup env
	printSetupDialog printSetup env
		= os_printsetupdialog False printSetup env
	
getPageDimensions	::	!PrintSetup !Bool	->	PageDimensions
getPageDimensions printSetup emulateScreenRes
	# (page,margins,resolution)	= os_getpagedimensions printSetup emulateScreenRes
	= {page=page, margins=margins, resolution=resolution}

instance == PageDimensions
  where
	(==) {page=page1,margins=margins1,resolution=resolution1}
		 {page=page2,margins=margins2,resolution=resolution2}
		= page1==page2 && margins1==margins2 && resolution1==resolution2

fwritePrintSetup	::	!PrintSetup !*File -> *File
fwritePrintSetup printSetup file
	#!	string	= os_printsetuptostring printSetup
		hexChars	= [ nibbleToChar (if low (lowNibble string.[i]) (highNibble string.[i]))
						\\ i<-[0..(size string)-1], low<-[True, False] ]
	= fwrites (toString hexChars+++"!") file
	where
		lowNibble ch	= (toInt ch) bitand 0xF
		highNibble ch	= ((toInt ch)>>4) bitand 0xF
		nibbleToChar nibble
			|	10<=nibble && nibble<=15	= toChar (nibble-10+(toInt 'A'))
			|	 0<=nibble && nibble<=9		= toChar (nibble+(toInt '0'))
			
freadPrintSetup		::	!*File !*env -> (!Bool, !PrintSetup, !*File, !*env)	| PrintSetupEnvironments env
freadPrintSetup file env
	#!	(hexChList, file)	= readline [] file
		chList				= map hexToChar (pair hexChList)
		printSetup			= os_stringtoprintsetup (toString chList)
		(valid, env)		= os_printsetupvalid printSetup env
	|	not valid
		#!	(defaultPS, env)= os_defaultprintsetup env
		= (False, defaultPS, file ,env)
	= (True, printSetup, file, env)
  where
	readline akku file
		#!	(ok, ch, file)	= freadc file
		|	ok && isMember ch (['0'..'9']++['A'..'F'])
			= readline [ch:akku] file
		= (reverse akku, file)
	pair [] = []
	pair [x] = [(x,'0')]
	pair [x,y:rest] = [(x,y): pair rest]	
	hexToChar (lowNibble,highNibble)
		= (nibbleToInt lowNibble)+16*(nibbleToInt highNibble)
	nibbleToInt ch
		|	'A'<=ch && ch<='F'	= (toInt ch) - (toInt 'A') + 10
		|	'0'<=ch && ch<='9'	= digitToInt ch


print :: !Bool !Bool
		 .(PrintInfo !*Picture -> ([DrawFunction],!*Picture))
         !PrintSetup !*printEnv
      -> (!PrintSetup,!*printEnv)
      | PrintEnvironments printEnv
print doDialog emulateScreen prFun printSetup printEnv
	# (finalState,printEnv) = os_printpageperpage doDialog emulateScreen 0 initFun stateTransition printSetup printEnv
	= case finalState of
		Cancelled _						->	(printSetup,printEnv)
		StartedPrinting (_,printSetup2)	->	(printSetup2,printEnv)
  where
  	initFun _ printInfo=:{printSetup} picture
  		# (drawFuns,picture) = prFun printInfo picture
  		= ((isEmpty drawFuns,zeroOrigin), ((drawFuns,printSetup),picture))
	stateTransition (([drawFun:rest],printSetup),picture)
  		=((isEmpty rest,zeroOrigin), ((rest,printSetup), drawFun picture))

zeroOrigin :== (0,0)   		

printUpdateFunction
		:: 	!Bool (UpdateFunction *s) [Rectangle] *s 
			!PrintSetup !*printEnv 
		-> 	((*s, !PrintSetup), !*printEnv)
		| PrintEnvironments printEnv
printUpdateFunction doDialog updateFunc rectangles s printSetup printEnv
	# (result, printEnv) = os_printpageperpage doDialog True s initState pageTrans printSetup printEnv
	  (s, outPrintSetup) = case result of
				StartedPrinting (s,outPrintSetup,_) -> (s,outPrintSetup)
				Cancelled s							-> (s, printSetup)
	= ((s, outPrintSetup), printEnv)
  where
	initState s printInfo=:{ printSetup, jobInfo={range=(first,last), copies} } picture
		= (	( isEmpty printedClips, fst (hd printedClips)),
			(	(s,printSetup,printedClips),picture )
		  )
		where
			{page=(wP,hP)}	= getPageDimensions printSetup True
			printedClips = flatten (repeatn copies (allClips % (first-1,last-1)))
			allClips = flatten (map clipsOfOneRectangle rectangles)
			clipsOfOneRectangle rectangle
				= clipRectangles
				where
					(x1,y1,x2,y2) = RectangleToRect rectangle
					wR = x2-x1+1
					hR = y2-y1+1
					columns = [0..(ceilOfRatio wR wP)-1]
					rows = [0..(ceilOfRatio hR hP)-1]
					clipRectangles = [ ( ( c*wP+x1, r*hP+y1 ),
										 ( min ((c+1)*wP+x1) x2,
										   min ((r+1)*hP+y1) y2
										 )) \\ r<-rows,c<-columns]
					ceilOfRatio num denum 		// ceil (num/denom)
						| num mod denum == 0
							= num/denum
						= num/denum + 1
					min x y
						| x>y = y
						=x
	pageTrans ((s,printSetup,[clipRect:rest]), picture)
		# (s,drawFunctions) = updateFunc [clipRect] s
		= ( (isEmpty rest,fst (hd rest)),
		 	( (s,printSetup,rest),seq drawFunctions (clpPP clipRect picture) )
		  )



printPagePerPage ::	!Bool !Bool 
					.x
					.(.x -> .(PrintInfo -> .(*Picture -> ((.Bool,Point),(.state,*Picture)))))
					((.state,*Picture) -> ((.Bool,Point),(.state,*Picture)))
					!PrintSetup !*printEnv
				-> 	(Alternative .x .state,!*printEnv)
				|	PrintEnvironments printEnv
printPagePerPage a b c d e f g
	= os_printpageperpage a b c d e f g

instance PrintEnvironments World
  where
	os_printpageperpage p1 p2 p3 p4 p5 p6 world
		= accFiles (os_printpageperpage p1 p2 p3 p4 p5 p6) world

printSetupTypical	:: Bool
printSetupTypical = OSprintSetupTypical